import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.*;

//*************************************************************************************************
/**
 * Diese Klasse repraesentiert einen View. Er stellt den Wert des Models in
 * einem Textfeld dar.
 * 
 * @author Marc Votteler
 * @version 1.0
 */
public class ViewField extends JPanel implements ChangeListener
{
//*************************************************************************************************
   /**
    * Referenz auf das eigentliche Textfeld.
    */
   private JTextField    field;

//*************************************************************************************************
   /**
    * Konstruktor.
    * Hier wird das Erscheinungsbild des Views definiert.
    */
   public ViewField(String label)
   {
      JPanel    labelPanel;
      JPanel    fieldPanel;
      
      this.setLayout(new GridLayout(2, 1));
      this.setBorder(new BevelBorder(BevelBorder.RAISED));
      
      labelPanel = new JPanel();
      labelPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
      labelPanel.add(new JLabel(label));
      this.add(labelPanel);
      
      field = new JTextField(5);
      field.setEditable(false);
      field.setHorizontalAlignment(JTextField.CENTER);
      field.setBorder(new BevelBorder(BevelBorder.LOWERED));      

      fieldPanel = new JPanel();
      fieldPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
      fieldPanel.add(field);
      this.add(fieldPanel);
   }
   
//*************************************************************************************************
   /**
    * Diese Methode ist die Implementierung aus dem ChangeListener. 
    * Hier werden die ChangeEvents aufgefangen und ausgewertet, d.h.
    * der Wert des Models wird abgefragt und im Textfeld dargestellt.
    * 
    * @param e Generierter ChangeEvent
    */
   public void stateChanged(ChangeEvent e)
   {
      Model model;
      
      // eine Referenz auf das Objekt das den Event ausgeloest holen 
      model        = (Model) e.getSource();            
      field.setText(String.valueOf(model.getValue())); 
   }
}