import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.*;

//*************************************************************************************************
/**
 * Diese Klasse repraesentiert einen <code>Controller</code> mit einem 
 * Button. Sie ist vom JPanel abgeleitet um sie direkt
 * in das entsprechende Fenster zu integrieren. Als weiteres
 * hat sie die Interfaces <code>ActionListener</code> und <code>Controller</code>
 * implementiert. Mit Hilfe des <code>ActionListener</code>s kann auf
 * Eingaben im Textfeld reagiert werden (fireChangeEvent()).
 * Das Interface <code>Controller</code> dient der Vereinheitlichung 
 * aller Kontroller-Klassen.
 * 
 * @author Marc Votteler
 * @version 1.0
 */
public class ViewBar extends JPanel implements javax.swing.event.ChangeListener
{
//*************************************************************************************************
   /**
    * Uebergabeparameter fuer den Konstruktor fuer einen horizontalen Balken.
    */
   public final static int HORIZONTAL = JProgressBar.HORIZONTAL;

   /**
    * Uebergabeparameter fuer den Konstruktor fuer einen vertikalen Balken.
    */
   public final static int VERTICAL   = JProgressBar.VERTICAL;
   
   /**
    * Referenz auf den eigentlichen Balken.
    */
   private JProgressBar    bar;

//*************************************************************************************************
   /**
    * Konstruktor.
    * Hier wird das Erscheinungsbild des Views definiert.
    * 
    * @param label Beschriftung des Balkens
    * @param orientation Ausrichtung des Balkens (HORIZONTAL / VERTICAL)
    */
   public ViewBar(String label, int orientation)
   {
      JPanel    labelPanel;
      
      this.setLayout(new GridLayout(2, 1));
      this.setBorder(new BevelBorder(BevelBorder.RAISED));
      
      labelPanel = new JPanel();
      labelPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
      labelPanel.add(new JLabel(label));
      this.add(labelPanel);
      
      bar = new JProgressBar();
      bar.setMaximum(10);
      bar.setMinimum(0);
      bar.setOrientation(orientation);
      bar.setBorder(new BevelBorder(BevelBorder.LOWERED));      
      this.add(bar);
   }
   
//*************************************************************************************************
   /**
    * Diese Methode ist die Implementierung aus dem ChangeListener. 
    * Hier werden die ChangeEvents aufgefangen und ausgewertet.
    * 
    * @param e Generierter ChangeEvent
    */
   public void stateChanged(ChangeEvent e)
   {
      Model model;
      
      // eine Referenz auf das Objekt das den Event ausgeloest holen 
      model        = (Model) e.getSource();            
      bar.setValue(model.getValue()); 
   }
}