import javax.swing.event.*;

//*************************************************************************************************
/**
 * Diese Klasse repraesentiert ein/das <code>Model</code>, also die
 * Datenhaltung. Sie hat das Interface <code>ChangeListener</code>
 * implementiert um von den Controllern darueber informiert
 * werden zu koennen wenn es seine Daten aendern soll.
 * 
 * @author Marc Votteler
 * @version 1.0
 */
public class Model implements ChangeListener
{
//*************************************************************************************************
   /**
    * Definition des minimal zu erreichenden Wertes
    */
   private  static final int  MIN_VALUE   =  0;

   /**
    * Definition des maximal zu erreichenden Wertes
    */
   private  static final int  MAX_VALUE   =  10;
   
   /**
    * Liste mit allen Listenern die im Falle einer Aenderung im Model informiert werden wollen.
    */
   private  EventListenerList listenerList;

   /**
    * Memberdatum, dass den eigentlichen Wert enthaelt
    */
   private  int               value;
   
//*************************************************************************************************
   /**
    * Dies ist der Konstruktor.
    */
   public Model()
   {
       listenerList = new EventListenerList();
   }
    
//*************************************************************************************************
   /**
    * Diese Methode liefert den aktuellen Wert. Benutzt wird 
    * diese Methode vom View.
    */
   public int getValue()
   {
       return value;
   }
    
//*************************************************************************************************
   /**
    * Methode zum registrieren von ChangeListener-Objekten
    * die benachrichtigt werden sollen.
    * 
    * @param listener ChangeListener-Objekt
    */   
   public void addChangeListener(ChangeListener listener)
   {
      listenerList.add(ChangeListener.class, listener);
      // wenn sich hier einer registriert dann wird er gleich vom aktuellen Stand informiert
      listener.stateChanged(new ChangeEvent(this));
   }

//*************************************************************************************************
   /**
    * Methode um ein ChangeListener-Objekt aus der Liste der
    * registrierten ChangeListener-Objekten zu loeschen.
    * 
    * @param listener ChangeListener-Objekt
    */   
   public void removeChangeListener(ChangeListener listener)
   {
      listenerList.remove(ChangeListener.class, listener);
   }
   
//*************************************************************************************************
   /**
    * Diese Methode "feuert" den ChangeEvent an alle registrierten
    * ChangeListener die Views.
    */   
   private void fireChangeEvent()
   {
      Object[]       listenerArr;
      ChangeListener listener;
      
      // 1. Array mit allen Horchern generieren
      listenerArr = listenerList.getListenerList();
      
      // 2. Da in der Liste alternierend "Klasse" und "Objekt" gespeichert sind -> i += 2
      for (int i = 0; i < listenerArr.length; i += 2)
      {
         // es koennten sich alle mglichen Listener registriert haben
         // aber nur die ChangeListenr sind von Interesse
         if (listenerArr[i] == ChangeListener.class)
         {
            listener = (ChangeListener) listenerArr[i+1];
            listener.stateChanged(new ChangeEvent(this));
         }
      }
   }

//*************************************************************************************************
   /**
    * Diese Methode ist die Implementierung aus dem ChangeListener. 
    * Hier werden die ChangeEvents aufgefangen und ausgewertet.
    * 
    * @param e Generierter ChangeEvent
    */
   public void stateChanged(ChangeEvent e)
   {
       Controller ctrl;
       int        ctrlValue;
        
        // eine Referenz auf das Objekt das den Event ausgeloest holen 
        ctrl        = (Controller) e.getSource();
            
        // den Wert fuer die Aenderung holen
        ctrlValue   = ctrl.getValue();
            
        // Kommando auswerten und Aenderungen am eigenen Wert vornehmen
        if(ctrl.getCommand().equals("+"))
        {
            // Kommando +
            value = Math.min(MAX_VALUE, value + ctrlValue);
        }
        else if(ctrl.getCommand().equals("-"))
        {
            // Kommando -
            value = Math.max(MIN_VALUE, value - ctrlValue);
        }
        else if(ctrl.getCommand().equals("="))
        {
            // Kommando =
            if      (ctrlValue < MIN_VALUE) value =   MIN_VALUE;
            else if (ctrlValue > MAX_VALUE) value =   MAX_VALUE;
            else                            value =   ctrlValue;
        }
        else
        {
            // ALARM - da will einer was und das kann ich nicht
        }
        
        this.fireChangeEvent();
   }
}