import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

//*************************************************************************************************
/**
 * Diese Klasse repraesentiert einen <code>Controller</code> mit einem 
 * Button. Sie ist vom JPanel abgeleitet um sie direkt
 * in das entsprechende Fenster zu integrieren. Als weiteres
 * hat sie das Interface <code>Controller</code> implementiert um als
 * solcher angesprochen und benutzt werden zu koennen.
 * 
 * @author Marc Votteler
 * @version 1.0
 */
public class ControllerButton extends JPanel implements Controller
{
//*************************************************************************************************
   /**
    * Member in dem das im Konstruktor uebergebene
    * Kommando gespeichert wird.
    * 
    * @see ControllerButton()
    */
   private String             command;
   
//*************************************************************************************************
   /**
    * Member in dem der im Konstruktor uebergebene
    * Wert gespeichert wird.
    * 
    * @see ControllerButton()
    */
   private int                value;
   
//*************************************************************************************************
   /**
    * Dies ist einer Art Array, in dem <code>EventListenr</code> gespeichert werden
    * koennen. Soll ein Event ausgeloest werden, so braucht man nur die
    * Eintraege in dieser Liste durchgehen und bei jedem Objekt die 
    * Methode <code>stateChanged(...)</code> aufrufen.
    * 
    * @see addChangeListener()
    * @see removeChangeListener()
    * @see fireChangeEvent()
    */
   private EventListenerList  listenerList;

//*************************************************************************************************
   /**
    * Hierbei handelt es sich um den eigentlichen Button.
    */
   private JButton            button;
    
//*************************************************************************************************
	/**
	 * Konstruktor.
	 * 
	 * @param label darzustellender Text (Ueberschrift)
	 * @param command Kommando, das die Art beschreibt, wie die Daten im
	 * Falle eines Buttonclicks zu aendern sind.
	 * @param value Wert, der fuer die Veraenderung der Daten Verwendet werden soll
	 */
	public ControllerButton(String label, String command, int value)
	{
	  // Dient alles nur der Darstellung bzw. dem Handling im Applet
      JPanel panelButton;
      JPanel panelLabel;
     
      this.setLayout(new GridLayout(2, 1));	
      this.setBorder(new BevelBorder(BevelBorder.RAISED));

      listenerList = new EventListenerList();
      		
      panelLabel  = new JPanel();
      panelLabel.setLayout(new FlowLayout(FlowLayout.CENTER, 2, 2));
      panelLabel.add(new JLabel(label));
      this.add(panelLabel);
      		
      button  = new JButton(command);
      button.addActionListener(
      // Anonyme innere Klasse (seit JDK 1.1) als Actionlistener 
        new ActionListener()
        {
            public void actionPerformed(ActionEvent ae)
            {
                    fireChangeEvent();
            }
        });
      panelButton = new JPanel();
      panelButton.setLayout(new FlowLayout(FlowLayout.CENTER, 2, 2));
      panelButton.add(button);
      this.add(panelButton);
      
      // Parameter uebernehmen und die <EventListenerList> anlegen
      this.command   = command;
      this.value     = value;      
   }

//*************************************************************************************************
	/**
	 * Liefert die Anweisung wie die Daten geaendert werden
	 * sollen.
	 * 
	 * @return Kommandostring
	 */
	public String getCommand()
	{
	    return command;
	}
	
	
//*************************************************************************************************
	/**
	 * Liefert den Wert mit dem die Daten Modifiziert werden sollen.
	 * 
	 * @return Modifizierungswert
	 */
	public int getValue()
	{
	    return value;
	}

//*************************************************************************************************
   /**
    * Methode zum registrieren von ChangeListener-Objekten.
    * Diese werden dann durch den Aufruf der Methode
    * <code>fireChangeEvent()</code> ueber eine Zustandsaenderung
    * informiert.
    * 
    * @param listener ChangeListener-Objekt
    */   
   public void addChangeListener(ChangeListener listener)
   {
      listenerList.add(ChangeListener.class, listener);
      // wenn sich hier einer registriert dann wird er gleich vom aktuellen Stand informiert
      listener.stateChanged(new ChangeEvent(this));
   }

//*************************************************************************************************
   /**
    * Methode um ein ChangeListener-Objekt aus der Liste der
    * registrierten ChangeListener-Objekte zu loeschen.
    * 
    * @param listener ChangeListener-Objekt das entfernt werden soll
    */   
   public void removeChangeListener(ChangeListener listener)
   {
      listenerList.remove(ChangeListener.class, listener);
   }
      
//*************************************************************************************************
   /**
    * Ueber diese Methode werden die Events an alle registrierten
    * <code>ChangeListener</code> versendet. Dazu wird innerhalb der Methode
    * der Inhalt der <code>EventListenerList</code> in einem Array vom Typ
    * <code>Object</code> gespeichert und dann ausgelesen. Es steht jeweils
    * abwechselnd immer der Typ des Listeners (hier immer <code>ChangeListener</code>
    * und dann das Listener-Objekt selber in dem Array. Bei den
    * Listener-Objekten wird jeweils die Methode <code>stateChanged()</code>
    * aufgerufen.
    * 
    * @see Model.stateChanged()
    */   
   public void fireChangeEvent()
   {
      Object[]       listenerArr;
      ChangeListener listener;
         
      // 1. Array mit allen Listenern generieren
      listenerArr = listenerList.getListenerList();
         
      // 2. Da in der Liste alternierend "Klasse" und "Objekt" gespeichert sind -> i += 2
      for (int i = 0; i < listenerArr.length; i += 2)
      {
         // es koennten sich alle mglichen Listener registriert haben
         // aber nur die ChangeListenr sind von Interesse
         if (listenerArr[i] == ChangeListener.class)
         {
            listener = (ChangeListener) listenerArr[i+1];
            // hier wird dem registrierten Listener bescheid gegeben, dass sich etwas
            // geaendert hat. Ihm wird zusaetzlich eine Referenz dieser Instanz uebergeben
            // damit er nich dem Wert und dem Kommando fragen kann.
            listener.stateChanged(new ChangeEvent(this));
         }
      }
   }
}

