import javax.swing.event.*;

//*************************************************************************************************
/**
 * Dieses Interface dient als Basis fuer alle Controller und definiert die erforderlichen
 * Basismethoden, die von den Implementierungen dieses Controllers bereitgestellt werden
 * muessen.
 * 
 * @author Marc Votteler
 * @version 1.0
 */
public interface Controller
{
//*************************************************************************************************
   /**
   * Gibt das Auszufuehrende Kommando.
   * 
   * @return Kommandostring
   */
   public String getCommand();
	
	
//*************************************************************************************************
   /**
    * Gibt den Wert mit dem die Daten Modifiziert werden sollen. Im Normalfall
    * wuerde man hier kein <code>int</code> sondern ein <code>Object</code> als Rueckgabewert definieren
    * um flexibler zu sein.
    * 
    * @return Modifizierungswert
    */
   public int getValue();

//*************************************************************************************************
   /**
    * Methode zum registrieren von ChangeListener-Objekten
    * die benachrichtigt werden sollen.
    * 
    * @param listener ChangeListener-Objekt
    */   
   public void addChangeListener(ChangeListener listener);

//*************************************************************************************************
   /**
    * Methode um ein ChangeListener-Objekt aus der Liste der
    * registrierten ChangeListener-Objekten zu loeschen.
    * 
    * @param listener ChangeListener-Objekt
    */   
   public void removeChangeListener(ChangeListener listener);

//*************************************************************************************************
   /**
    * Diese Methode "feuert" den ChangeEvent an alle registrierten
    * ChangeListener die Views.
    *
    */   
   public void fireChangeEvent();
}