import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;

//*************************************************************************************************
/**
 * Diese Klasse repraesentiert das Applet welches als Kontainer
 * fuer die Controller und Views dient.
 * 
 * @author Marc Votteler
 * @version 1.0
 */
public class BarApplet extends JApplet
{
//*************************************************************************************************
   /**
    * Referenz auf ein Balken-View
    */
    private ViewBar             viewBarH;

   /**
    * Referenz auf ein Balken-View
    */
    private ViewBar             viewBarV;

   /**
    * Referenz auf ein Textfeld-View
    */
    private ViewField           viewField;

   /**
    * Referenz auf einen Button-Controller
    */
    private ControllerButton    ctrlBPlus;

   /**
    * Referenz auf einen Button-Controller
    */
    private ControllerButton    ctrlBMinus;

   /**
    * Referenz auf einen Textfeld-Controller
    */
    private ControllerField     ctrlField;

   /**
    * Referenz auf das Model
    */
    private Model               model;
    
//*************************************************************************************************
    /**
    * Einsprungstelle vom Browser. Hier wird die globale Zusammenstellung der Komponenten
    * erledigt. Als weiteres werden hier die vorhanden Listener bei den entsprechenden
    * Objekten registriert.
    */
    public void init()
    {
        JPanel ctrlPanel;
        JPanel viewPanel;
        JPanel centerPanel;
        JPanel northPanel;
        JPanel labelPanelC;
        JPanel labelPanelV;
        
        this.getContentPane().setLayout(new BorderLayout(2, 2));
        
        // Beschriftung "Controller" und "View" einfuegen
        northPanel = new JPanel();
        northPanel.setLayout(new GridLayout(1, 2));
        
        labelPanelC = new JPanel();
        labelPanelC.setLayout(new FlowLayout(FlowLayout.CENTER, 10, 2));      
        labelPanelC.add(new JLabel("Controller"));
        northPanel.add(BorderLayout.NORTH, labelPanelC);
        
        labelPanelV = new JPanel();
        labelPanelV.setLayout(new FlowLayout(FlowLayout.CENTER, 10, 2));      
        labelPanelV.add(new JLabel("View"));        
        northPanel.add(labelPanelV);
        
        this.getContentPane().add(BorderLayout.NORTH, northPanel);
        
        // Controller einfuegen
        centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(1, 2));

        model = new Model();
        
        ctrlPanel = new JPanel();
        ctrlPanel.setLayout(new GridLayout(3, 1, 2, 2));
        ctrlPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
        
        ctrlBPlus = new ControllerButton("1. Controller", "+", 1);
        ctrlPanel.add(ctrlBPlus);
        
        ctrlBMinus = new ControllerButton("2. Controller", "-", 1);
        ctrlPanel.add(ctrlBMinus);
        
        ctrlField = new ControllerField("3. Controller", "=");
        ctrlPanel.add(ctrlField);
        
        centerPanel.add(ctrlPanel);
        
        // View einfuegen
        viewPanel = new JPanel();
        viewPanel.setLayout(new GridLayout(3, 1, 2, 2));
        viewPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
        
        viewBarH = new ViewBar("1. View", ViewBar.HORIZONTAL);
        viewPanel.add(viewBarH);
        
        viewBarV = new ViewBar("2. View", ViewBar.VERTICAL);
        viewPanel.add(viewBarV);
        
        viewField = new ViewField("3. View");
        viewPanel.add(viewField);
        
        centerPanel.add(viewPanel);        
        
        this.getContentPane().add(BorderLayout.CENTER, centerPanel);
        
        // registrieren der einzelen Eventlistener
        ctrlBPlus.addChangeListener(model);
        ctrlBMinus.addChangeListener(model);
        ctrlField.addChangeListener(model);
        
        model.addChangeListener(viewBarH);
        model.addChangeListener(viewBarV);
        model.addChangeListener(viewField);
    }
}